/*------------------------------------------------------------------------------*
 * File Name: TextFormat.h														*
 * Creation: Jasmine															*
 * Purpose: Origin C header file for Origin basic Data Vector types				*
 * Copyright (c) OriginLab Corp.	2002 - 2007									*
 * All Rights Reserved															*
 * Modifications:																*
 *	Jasmine 04/03/07 REMOVE_NUMERIC_IF_NUMERIC_DEFAULT_DECIMAL					*
 *	Jasmine 04/19/07 MORE_WORK_ON_NUMERIC_DEFAULT_DECIMAL						*
 *	Folger 05/09/07 ADD_STYLE_CONTROL											*
 *	Jasmine 05/10/07 MODIFICATION_FORMAT_STRING_FOR_DATE_TIME					*
 *	Folger 05/14/07 MODIFICATION_TEXTCONTROL_MERGE								*
 *	Folger 05/15/07 FIXED_TEXTCONTROL_MERGE										*
 *	Folger 05/15/07 MODIFICATION_TEXTCONTROL_OPTION								*
 *	Jasmine 06/12/07 ADD_RICH_TEXT_CHEKBOX										*
 *	Folger 06/27/07 FIX_ORIGINTEXTCONTROL_SHOW									*
 *	Nicole 07/05/2007 v8.0655 REMOVE_SPACE_FOR_LOCATION_STRING					*
 *	Folger 07/10/07 ADD_ELLIPSIS_INTO_TEXT_FORMAT								*
 *	Folger 07/23/07 SHOW_RICH_TEXT_WHEN_LONG_NAME_CHOSEN						*
 *	Jasmine 07/26/07 NAME_STYLE_N_IS_NOT_RELIABLE								*
 *	Folger 08/17/07 FIX_BUGS_IN_COMBO_DIGITS_VISIBILITY							*
 *	Jasmine 09/06/07 SHOW_ERROR_MESSAGE											*
 *	Jasmine 09/21/07 QA70-10401 SELDOM_USE_SO_REMOVE_FLOOD						*
 *	Jasmine 09/21/07 QA70-10401 ELLIPSIS_AND_ALLOWENTER_NO_USE_WHEN_RICH_TEXT_CHECK *
 *	Jasmine 09/21/07 QA70-10401 HIDE_ELLIPSIS_FOR_LNAME_UNIT_COMMENT			*
 *	Folger 02/26/08 QA80-11113-P2 CENTRALIZE_SET_CONTROL_AND_FORMAT_CHANGED		*
 *	CPY 2/26/08 QA80-11159 ORIGIN_TEXT_IN_WKS_CELL_NOT_ALLOW_MULTILINE			*
 *	CPY 2/26/08 QA70-11111 IGNORE_BLANK_MISSING_RANGE_STYLE						*
 *	Kyle 07/22/2009 QA80-12339-P1 WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
 *	Kyle 07/28/2009 QA80-13951 UPPER_CASE_H_FOR_24_HOURS_SYSTEM_AND_LOWER_CASE_H_FOR_12_HOURS_SYSTEM
 *	Kyle 07/31/2009 QA80-12339-P4 WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION	*
 *	Kyle 08/12/2009 QA80-12339-P6 WKS_PROPERTIES_FORMAT_ADD_COLUMN_LABELS_OPTION*
 *	Jasmine 11/11/09 QA80-14602 ADD_READONLY_CHECKBOX							*
 *	CPY 11/13/09 READ_ONLY_CHANGED_TO_DISABLE_EDIT								*
 *------------------------------------------------------------------------------*/
 
#ifndef __TEXT_FORMAT__
#define __TEXT_FORMAT__
 
#define STR_DATA_DISPLAY_MODE_LIST		_L("Decimal:1000|Scientific:1E3|Engineering:1K|Decimal:1,000")
#define STR_DECIMAL_DIGITS_MODE_LIST	_L("Default Decimal Digits|Set Decimal Places=|Significant Digits=")
#define STR_DECIMAL_PLACES_LABEL		_L("Decimal Number")
#define STR_SIGNIFICANT_PLACES_LABEL	_L("Significant Digits")
///Jasmine 05/10/07 MODIFICATION_FORMAT_STRING_FOR_DATE_TIME, copy from DataObjectManager
///Kyle 07/28/2009 QA80-13951 UPPER_CASE_H_FOR_24_HOURS_SYSTEM_AND_LOWER_CASE_H_FOR_12_HOURS_SYSTEM
//#define STR_COL_TIME_DISPLAY_LIST		"HH:mm|HH|HH:mm:ss|HH:mm:ss.##|HH pm|HH:mm pm|mm:ss|mm:ss.##|HHmm|HHmmss|HH:mm:ss.###|DDD|DDD:hh|DDD:hh:mm|DDD:hh:mm:ss|DDD:hh:mm:ss.##|DDD:hh:mm:ss.######"
#define STR_COL_TIME_DISPLAY_LIST		"HH:mm|HH|HH:mm:ss|HH:mm:ss.##|hh pm|hh:mm pm|mm:ss|mm:ss.##|HHmm|HHmmss|HH:mm:ss.###|DDD|DDD:HH|DDD:HH:mm|DDD:HH:mm:ss|DDD:HH:mm:ss.##|DDD:HH:mm:ss.######"
///End UPPER_CASE_H_FOR_24_HOURS_SYSTEM_AND_LOWER_CASE_H_FOR_12_HOURS_SYSTEM
///End MODIFICATION_FORMAT_STRING_FOR_DATE_TIME
///Jasmine 04/19/07 MORE_WORK_ON_NUMERIC_DEFAULT_DECIMAL
#define	DEC_PLACES_TO_SDIGITS(n)	((n)+3)
#define	SDIGITS_TO_DEC_PLACES(n)	((n)>=3? (n)-3:0)
///End MORE_WORK_ON_NUMERIC_DEFAULT_DECIMAL

#define ADD_STYLE_CONTROL	///Jasmine 06/12/07 ADD_RICH_TEXT_CHEKBOX

enum {	NUMERIC_DEFAULT_DECIMAL,
		NUMERIC_SET_DECIMAL_PLACES,
		NUMERIC_SET_SIGNIFICANT_DIGITS
};
///Jasmine 05/10/07 MODIFICATION_FORMAT_STRING_FOR_DATE_TIME
enum {	TYPE_TEXT_NUMERIC,
		TYPE_TIME,
		TYPE_DATE
};
///End MODIFICATION_FORMAT_STRING_FOR_DATE_TIME
static void _put_format_type_to_gui(int& nFormat)
{
	switch(nFormat)
	{
	case LABELS_NUM_SCI:
		nFormat = 1;//Scientific:1E3
		break;
	case LABELS_NUM_ENG:
		nFormat = 2; //Engineering:1K
		break;
	case LABELS_NUM_COMMA:
		nFormat = 3;//Decimal:1,000
		break;
	default:
		nFormat = 0;//Decimal:1000
		break;
	}
}
static void _get_format_type_from_gui(int& nFormat)
{
	switch(nFormat)
	{
	case 0://Decimal:1000
		nFormat = -1;
		break;
	case 1://Scientific:1E3
		nFormat = LABELS_NUM_SCI;
		break;
	case 2://Engineering:1K
		nFormat = LABELS_NUM_ENG; 
		break;
	case 3://Decimal:1,000
		nFormat = LABELS_NUM_COMMA;
		break;
	}
}
///Jasmine 05/10/07 MODIFICATION_FORMAT_STRING_FOR_DATE_TIME
static string get_date_str(time_t &ltime, WORD wFormat)
{
	SYSTEMTIME st;
	TM tmLocal;
	double dDate;
	
	convert_time_to_local( &ltime , &tmLocal);
    tm_to_systemtime(&tmLocal, &st);
	SystemTimeToJulianDate(&dDate, &st);
	return get_date_str(dDate, wFormat);
}

static string _get_current_data_display_list()
{
	//Get today date
	time_t ltime;
	time( &ltime );
	
	string strShort, strFormat1, strFormat2;
	strShort=get_date_str(ltime, LDF_SHORT);
	for(int nFormat=LDF_SHORT; nFormat<=LDF_NUMERICYEAR_2DIGIT; nFormat++)
		strFormat1+=get_date_str(ltime, nFormat)+"|";
	
	for(nFormat=LDF_ALPHAMON_3CHR; nFormat<=LDF_QUARTER; nFormat++)
		strFormat2+=get_date_str(ltime, nFormat)+"|";
	/// Nicole 07/05/2007 v8.0655 REMOVE_SPACE_FOR_LOCATION_STRING
	/*
	strFormat2+=get_date_str(ltime, LDF_CUSTOM1)+_L(" (Global Custom1)|");
	strFormat2 += get_date_str(ltime, LDF_CUSTOM2)+_L(" (Global Custom2)|");
	*/
	strFormat2+=get_date_str(ltime, LDF_CUSTOM1)+" " + _L("(Global Custom1)|");
	strFormat2 += get_date_str(ltime, LDF_CUSTOM2)+" " + _L("(Global Custom2)|");
	/// end REMOVE_SPACE_FOR_LOCATION_STRING
	
	//strFormat2 += STR_CUSTOM_FORMAT_LABEL;
	return strFormat1+strShort+" HH:mm|"+strShort+" HH:mm:ss|"+"yyMMdd|yyMMdd HH:mm|yyMMdd HH:mm:ss|yyMMdd HHmm|yyMMdd HHmmss|"+strFormat2;
}

static int _get_list_size(LPCSTR lpcszList, char ch = '|')
{
	string str(lpcszList);
	vector<string> vs;
	int nSize = str.GetTokens(vs, ch);
	return nSize;
}
///Jasmine 06/12/07 ADD_RICH_TEXT_CHEKBOX
static bool _rich_text_change_event(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{	
	TreeNode trWrapText = tree_get_node_by_tagname(myTree, "WrapText", true);
	TreeNode trFloat = tree_get_node_by_tagname(myTree, "Float", true);
	//TreeNode trFlood = tree_get_node_by_tagname(myTree, "Flood", true);	///Jasmine 09/21/07 QA70-10401 SELDOM_USE_SO_REMOVE_FLOOD
	///Jasmine 09/21/07 QA70-10401 ELLIPSIS_AND_ALLOWENTER_NO_USE_WHEN_RICH_TEXT_CHECK 
	TreeNode trEllipsis = tree_get_node_by_tagname(myTree, "Ellipsis", true);
	//----- CPY 2/26/08 QA80-11159 ORIGIN_TEXT_IN_WKS_CELL_NOT_ALLOW_MULTILINE
	/*
	TreeNode trAllowEnter = tree_get_node_by_tagname(myTree, "AllowEnter", true);
	
	if(!trWrapText.IsValid() || !trFloat.IsValid() || !trEllipsis.IsValid() || !trAllowEnter.IsValid())
		return false;
	trWrapText.Enable = trFloat.Enable = trEllipsis.Enable = trAllowEnter.Enable = (!trNode.Show || !trNode.nVal);
	///End ELLIPSIS_AND_ALLOWENTER_NO_USE_WHEN_RICH_TEXT_CHECK
	*/
	if(!trWrapText.IsValid() || !trFloat.IsValid() || !trEllipsis.IsValid())
		return false;
	trWrapText.Enable = trFloat.Enable = trEllipsis.Enable  = (!trNode.Show || !trNode.nVal);
	//----- end ORIGIN_TEXT_IN_WKS_CELL_NOT_ALLOW_MULTILINE
	return true;
}
///Jasmine 09/06/07 SHOW_ERROR_MESSAGE
/*
//---------Folger 07/10/07 ADD_ELLIPSIS_INTO_TEXT_FORMAT
static bool _ellipsis_change_event(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode trAllowEnter = tree_get_node_by_tagname(myTree, "AllowEnter", true);
    if (trAllowEnter)
    {
    	bool bEnable = !trNode.nVal;
    	trAllowEnter.Enable = bEnable;
    	if(!bEnable)
    		trAllowEnter.nVal = false;
    }
	return true;
}
//---------end ADD_ELLIPSIS_INTO_TEXT_FORMAT
*/
///Jsamine 09/24/07 QA70-10353 CP_FIX_ALLOWENTER_BUG
/*
static bool _allow_enter_change_event(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode trEllipsis = tree_get_node_by_tagname(myTree, "Ellipsis", true);
    if (trEllipsis)
    	trEllipsis.Enable = false == trNode.nVal;
	return true;
}
*/
///End CP_FIX_ALLOWENTER_BUG
///End SHOW_ERROR_MESSAGE
///End ADD_RICH_TEXT_CHEKBOX
static bool _format_type_change_event(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode trDisplay = tree_get_node_by_tagname(myTree, "Display", true);
	TreeNode trDigitsMode = tree_get_node_by_tagname(myTree, "DigitsMode", true);
	TreeNode trDigitsNumber = tree_get_node_by_tagname(myTree, "DigitsNumber", true);
	if(!trDisplay.IsValid() || !trDigitsMode.IsValid() || !trDigitsNumber.IsValid())
		return false;
	int nFormatType = trNode.nVal;
	string strCombo;
	switch(nFormatType)
	{
	case TYPE_TEXT_NUMERIC:
		strCombo = STR_DATA_DISPLAY_MODE_LIST;
		break;
	case TYPE_TIME:
		strCombo = STR_COL_TIME_DISPLAY_LIST;
		break;
	case TYPE_DATE:
		strCombo = _get_current_data_display_list();
		break;
	}
	trDisplay.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	if(trDisplay.nVal >= _get_list_size(strCombo))
		trDisplay.nVal = 0;
	trDigitsMode.Show = trDigitsNumber.Show = false;	
	if(TYPE_TEXT_NUMERIC == nFormatType)
	{
		trDigitsMode.Show = true;
		_digits_mode_event(myTree, nRow, nCol, trDigitsMode, dwCntrl, nType, theDlg);
	}
	return true;
}
///End MODIFICATION_FORMAT_STRING_FOR_DATE_TIME
static bool _digits_mode_event(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode trDigitsNumber = tree_get_node_by_tagname(myTree, "DigitsNumber", true);
	if(!trDigitsNumber.IsValid())
		return false;
	trDigitsNumber.Show = trNode.nVal > 0;
	if(1 == trDigitsNumber.Show)
	{
		///Jasmine 04/19/07 MORE_WORK_ON_NUMERIC_DEFAULT_DECIMAL
		string strOldLabel;
		trDigitsNumber.GetAttribute(STR_LABEL_ATTRIB, strOldLabel);
		string strLabel = NUMERIC_SET_DECIMAL_PLACES==trNode.nVal? STR_DECIMAL_PLACES_LABEL:STR_SIGNIFICANT_PLACES_LABEL;
		if(strOldLabel.CompareNoCase(strLabel))
		{
			trDigitsNumber.SetAttribute(STR_LABEL_ATTRIB, strLabel);
			int nSigDigits = atoi(trDigitsNumber.strVal);
			if(NUMERIC_SET_DECIMAL_PLACES == trNode.nVal)//sign digits -> decimal place	
				trDigitsNumber.strVal = SDIGITS_TO_DEC_PLACES(nSigDigits);
			if(NUMERIC_SET_SIGNIFICANT_DIGITS == trNode.nVal)//decimal place -> sign digits 	
				trDigitsNumber.strVal = DEC_PLACES_TO_SDIGITS(nSigDigits);
		}
		///End MORE_WORK_ON_NUMERIC_DEFAULT_DECIMAL
	}
	return true;
}
///Jasmine 04/19/07 MORE_WORK_ON_NUMERIC_DEFAULT_DECIMAL
static int _get_system_digits_setting()
{
	int nDigits;
	OriginSettings os;
	BOOL bRet =os.GetValue("Numeric.NumDecDigits", nDigits);
	return nDigits;
}
///End MORE_WORK_ON_NUMERIC_DEFAULT_DECIMAL
///Jasmine 05/10/07 MODIFICATION_FORMAT_STRING_FOR_DATE_TIME
//------ CPY 2/26/08 QA70-11111 IGNORE_BLANK_MISSING_RANGE_STYLE	
//static bool construct_text_format_tree(TreeNode& tr)
static bool construct_text_format_tree(TreeNode& tr, bool bShowMissingAsBlank = true)
//------
{
	if(!tr.IsValid())
		return error_report("tr is invalid");
	GETN_USE(tr)
		///Jasmine 06/12/07 ADD_RICH_TEXT_CHEKBOX
		///Folger 05/09/07 ADD_STYLE_CONTROL
#ifdef ADD_STYLE_CONTROL
		/// TD 01-05-2008 QA80-12470 LT_INVOKE_Worksheet_Properties_dialog
		//GETN_CHECK(OriginTextControl, _L("Rich Text"), 0) 	GETN_OPTION_EVENT_EX(_rich_text_change_event)
		GETN_CHECK(OriginTextControl, _L("Rich Text"), 0) 	GETN_OPTION_EVENT_EX(_rich_text_change_event)	GETN_ID(0x040e)
		/// end LT_INVOKE_Worksheet_Properties_dialog
		GETN_STR(Control, _L("Control"), "Edit Control") GETN_ID(OTID_STYLE_CONTROL)	
		GETN_CURRENT_SUBNODE.Show = false;	//always hide this node
#endif
		///End ADD_STYLE_CONTROL
		///End ADD_RICH_TEXT_CHEKBOX
		GETN_CHECK(AllowEnter, _L("Allow Enter"), 1)					GETN_ID(OTID_STYLE_ALLOW_ENTER)
		//GETN_OPTION_EVENT_EX(_allow_enter_change_event)	///Jasmine 09/06/07 SHOW_ERROR_MESSAGE	///Jsamine 09/24/07 QA70-10353 CP_FIX_ALLOWENTER_BUG
		GETN_CHECK(WrapText, _L("Wrap Text"), FALSE)					GETN_ID(OTID_STYLE_WRAP)
		GETN_CHECK(Float, _L("Float"), 1)								GETN_ID(OTID_STYLE_FLOAT)
		//GETN_CHECK(Flood, _L("Flood"), 1)								GETN_ID(OTID_STYLE_FLOOD)	///Jasmine 09/21/07 QA70-10401 SELDOM_USE_SO_REMOVE_FLOOD
		GETN_CHECK(ReadOnly, _L("Disable Editing"), 1)						GETN_ID(OTID_STYLE_READONLY)///Jasmine 11/11/09 QA80-14602 ADD_READONLY_CHECKBOX CPY 11/13/09 READ_ONLY_CHANGED_TO_DISABLE_EDIT changed from Read Only to Disable Editing
		//---------Folger 07/10/07 ADD_ELLIPSIS_INTO_TEXT_FORMAT
		GETN_LIST(Ellipsis, _L("Ellipsis"), 0, _L("None|...|###")) GETN_ID(OTID_STYLE_ELLIPSIS) //GETN_OPTION_EVENT_EX(_ellipsis_change_event)	///Jasmine 09/06/07 SHOW_ERROR_MESSAGE
		//---------end ADD_ELLIPSIS_INTO_TEXT_FORMAT
		//------ CPY 2/26/08 QA70-11111 IGNORE_BLANK_MISSING_RANGE_STYLE	
		//GETN_LIST(Merge, _L("Merge"), GMC_NONE, _L("None|Horizontal|Vertical|Both")) GETN_ID(OTID_STYLE_MERGE)
		//GETN_CHECK(BlankMissing, _L("Show Missing as Blank"), TRUE)		GETN_ID(OTID_STYLE_SHOWMISSINGBLANK)
		GETN_LIST(Merge, _L("Dynamic Merge"), GMC_NONE, _L("None|Horizontal|Vertical|Both")) GETN_ID(OTID_STYLE_MERGE)
		if(bShowMissingAsBlank)
		{
			GETN_CHECK(BlankMissing, _L("Show Missing as Blank"), TRUE)		GETN_ID(OTID_STYLE_SHOWMISSINGBLANK)
		}
		//------
		
		///Jasmine 03/27/07 MODIFICATION_FORMAT_STR
		GETN_STR(Format, _L("Format String"), "")								GETN_ID(OTID_STYLE_FORMAT)
		GETN_CURRENT_SUBNODE.Show = false;//always hide this node
		GETN_LIST(Type, _L("Format"), 0, _L("Text & Numeric|Time|Date"))			GETN_OPTION_EVENT_EX(_format_type_change_event)
		GETN_LIST(Display, _L("Display"), 0, STR_DATA_DISPLAY_MODE_LIST)	
		GETN_LIST(DigitsMode, _L("Digits"), 0, STR_DECIMAL_DIGITS_MODE_LIST)	GETN_OPTION_EVENT_EX(_digits_mode_event)
		GETN_STR(DigitsNumber, STR_SIGNIFICANT_PLACES_LABEL, "")
		GETN_CURRENT_SUBNODE.Show = false;
		///End MODIFICATION_FORMAT_STR
		
		///Kyle 07/22/2009 QA80-12339-P1 WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
#ifdef __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
		GETN_BEGIN_BRANCH(FontControl, _L("Font")) GETN_CHECKBOX_BRANCH(0)
			GETN_FONT(Face, _L("Font"), -1)											GETN_ID(OTID_STYLE_FONT_FACE)
			GETN_COMBO(Size, _L("Font Size"), 12, "|8|9|10|11|12|14|16|18|20|22|24|26|28|36|48|72")		GETN_ID(OTID_STYLE_FONT_SIZE)
			//GETN_FONT_SIZE(Size, _L("Font Size"), 12)		GETN_ID(OTID_STYLE_FONT_SIZE)
		GETN_END_BRANCH(FontControl)
		GETN_BEGIN_BRANCH(ColorControl, _L("Color")) GETN_CHECKBOX_BRANCH(0)
			GETN_COLOR(Color, _L("Color"), -1)		GETN_COLOR_CHOICE_OPTIONS(COLORLIST_SINGLE|COLORLIST_CUSTOM) GETN_ID(OTID_STYLE_COLOR)
			GETN_COLOR(FillColor, _L("Fill Color"), -1)		GETN_COLOR_CHOICE_OPTIONS(COLORLIST_SINGLE|COLORLIST_CUSTOM) GETN_ID(OTID_STYLE_FILL_COLOR)
		GETN_END_BRANCH(ColorControl)
#endif // __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
		///End WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS

	return true;
}
///End MODIFICATION_FORMAT_STRING_FOR_DATE_TIME

///Kyle 07/31/2009 QA80-12339-P4 WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
static void _update_text_format_structure(TreeNode& trText, bool bBranch)
{
	if(!trText)
		return;
	if(bBranch)
	{
		if(trText.FontControl || trText.ColorControl)				// the structure is correct, nothing to do
			return;
		trText.Face.Remove();
		trText.Size.Remove();
		trText.Color.Remove();
		trText.FillColor.Remove();

		GETN_USE(trText)
		GETN_BEGIN_BRANCH(FontControl, _L("Font")) GETN_CHECKBOX_BRANCH(0)
			GETN_FONT(Face, _L("Font"), -1)											GETN_ID(OTID_STYLE_FONT_FACE)
			GETN_COMBO(Size, _L("Font Size"), 12, "|8|9|10|11|12|14|16|18|20|22|24|26|28|36|48|72")		GETN_ID(OTID_STYLE_FONT_SIZE)
			//GETN_FONT_SIZE(Size, _L("Font Size"), 12)		GETN_ID(OTID_STYLE_FONT_SIZE)
		GETN_END_BRANCH(FontControl)
		GETN_BEGIN_BRANCH(ColorControl, _L("Color")) GETN_CHECKBOX_BRANCH(0)
			GETN_COLOR(Color, _L("Color"), -1)		GETN_COLOR_CHOICE_OPTIONS(COLORLIST_SINGLE|COLORLIST_CUSTOM) GETN_ID(OTID_STYLE_COLOR)
			GETN_COLOR(FillColor, _L("Fill Color"), -1)		GETN_COLOR_CHOICE_OPTIONS(COLORLIST_SINGLE|COLORLIST_CUSTOM) GETN_ID(OTID_STYLE_FILL_COLOR)
		GETN_END_BRANCH(ColorControl)
	}
	else
	{
		if(!trText.FontControl || !trText.ColorControl)				// the structure is correct, nothing to do
			return;

		trText.FontControl.Remove();
		trText.ColorControl.Remove();
		
		GETN_USE(trText)
		GETN_FONT(Face, _L("Font"), -1)											GETN_ID(OTID_STYLE_FONT_FACE)
		GETN_COMBO(Size, _L("Font Size"), 12, "|8|9|10|11|12|14|16|18|20|22|24|26|28|36|48|72")		GETN_ID(OTID_STYLE_FONT_SIZE)

		GETN_COLOR(Color, _L("Color"), -1)		GETN_COLOR_CHOICE_OPTIONS(COLORLIST_SINGLE|COLORLIST_CUSTOM) GETN_ID(OTID_STYLE_COLOR)
		GETN_COLOR(FillColor, _L("Fill Color"), -1)		GETN_COLOR_CHOICE_OPTIONS(COLORLIST_SINGLE|COLORLIST_CUSTOM) GETN_ID(OTID_STYLE_FILL_COLOR)
	}
}

static void _get_text_font_color_setting(TreeNode& trText, const TreeNode& trTextFmt, bool bBranch)
{
	if(!trText || !trTextFmt)
		return;
	TreeNode trFontControl = trText;
	TreeNode trColorControl = trText;
	if(bBranch)
	{
		trFontControl = trFontControl.FontControl;
		trColorControl = trColorControl.ColorControl;
	}
	ASSERT(trFontControl && trColorControl);

	bool bEnableFontControl = false;
	if(trTextFmt.Font && trTextFmt.Font.Face)
	{
		trFontControl.Face.nVal = trTextFmt.Font.Face.nVal;
		trFontControl.Face.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, false);
		bEnableFontControl = true;
	}
	else
	{
		trFontControl.Face.nVal = 0;
		trFontControl.Face.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, true);
	}
	if(trTextFmt.Font && trTextFmt.Font.Size)
	{
		trFontControl.Size.nVal = trTextFmt.Font.Size.nVal;
		trFontControl.Size.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, false);
		bEnableFontControl = true;
	}
	else
	{
		trFontControl.Size.nVal = 9;
		trFontControl.Size.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, true);
	}

	bool bEnableColorControl = false;
	if(trTextFmt.Color)
	{
		trColorControl.Color.nVal = trTextFmt.Color.nVal;
		trColorControl.Color.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, false);
		bEnableColorControl = true;
	}
	else
	{
		trColorControl.Color.nVal = SYSCOLOR_BLACK;
		trColorControl.Color.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, true);
	}
	if(trTextFmt.Fill && trTextFmt.Fill.FillColor)
	{
		trColorControl.FillColor.nVal = trTextFmt.Fill.FillColor.nVal;
		trColorControl.FillColor.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, false);
		bEnableColorControl = true;
	}
	else
	{
		trColorControl.FillColor.nVal = SYSCOLOR_WHITE;
		trColorControl.FillColor.SetAttribute(STR_ATTRIB_DYNACONTROL_UNDEFINED, true);
	}
	
	if(bBranch)
	{
		trFontControl.Use = bEnableFontControl;
		trColorControl.Use = bEnableColorControl;
	}
}
///End WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION

static bool get_text_format(const OriginObject& obj, TreeNode& tr, LPCSTR lpcszTagName)
{
	if(!obj.IsValid() || !tr.IsValid())
		return error_report("obj or tr is invalid");

	Tree trFmt;
	trFmt = obj.GetFormat(FPB_ALL, FOB_ALL & ~(FOB_LINK_STYLE|FOB_RANGE_STYLE), TRUE, TRUE);
	TreeNode trProp = trFmt;
	string strTagName = lpcszTagName;
	if(-1 < strTagName.Find("."))
	{
		///Jasmine 07/26/07 NAME_STYLE_N_IS_NOT_RELIABLE
		//trProp = tree_get_node_by_tagname(trProp, strTagName.GetToken(0, '.'), true);
		trProp = theme_tree_get_node_by_name_strval(trProp, strTagName.GetToken(0, '.'));
		if(!trProp)
			return error_report("trProp is invalid");
		///End NAME_STYLE_N_IS_NOT_RELIABLE
		strTagName = strTagName.GetToken(1, '.');
	}
	///Folger 05/15/07 FIXED_TEXTCONTROL_MERGE
	///Folger 05/14/07 MODIFICATION_TEXTCONTROL_MERGE
	string strOgName;
	//------ Folger 08/17/07 FIX_BUGS_IN_COMBO_DIGITS_VISIBILITY
	//bool bData;//int nCmp;		///Folger 05/15/07 MODIFICATION_TEXTCONTROL_OPTION	///Jasmine 06/12/07 ADD_RICH_TEXT_CHEKBOX
	bool bData = true;
	//------ End FIX_BUGS_IN_COMBO_DIGITS_VISIBILITY
	///Kyle 07/22/2009 QA80-12339-P1 WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
#ifdef __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
	bool bHeader = false;
	bool bLabel = false;
	bool bStandard = false;			///Kyle 07/31/2009 QA80-12339-P4 WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
	bool bCommonStyle = true;
#endif // __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
	///End WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS

	if (trProp.Name.IsValid())
	{
		///Kyle 07/31/2009 QA80-12339-P4 WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
#ifdef __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
		bCommonStyle = false;
#endif // __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
		///End WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
		strOgName = trProp.Name.strVal;
		///Jasmine 06/12/07 ADD_RICH_TEXT_CHEKBOX
		///Folger 05/15/07 MODIFICATION_TEXTCONTROL_OPTION
		//if (strOgName.CompareNoCase("ogData") == 0)
		//if ((nCmp = strOgName.CompareNoCase("ogData")) == 0)
		bData = !strOgName.CompareNoCase("ogData");

		///Kyle 07/22/2009 QA80-12339-P1 WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
#ifdef __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
		bHeader = !strOgName.CompareNoCase("Column Header") || !strOgName.CompareNoCase("Row Header");
		///Kyle 07/31/2009 QA80-12339-P4 WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
		//bLabel = bHeader && !bData;
		bStandard = !strOgName.CompareNoCase("Standard");
		///Kyle 08/12/2009 QA80-12339-P6 WKS_PROPERTIES_FORMAT_ADD_COLUMN_LABELS_OPTION
		//bLabel = !bHeader && !bData && !bStandard;
		bLabel = !strOgName.CompareNoCase("ogColLabel") || (!bHeader && !bData && !bStandard);
		///End WKS_PROPERTIES_FORMAT_ADD_COLUMN_LABELS_OPTION
		///End WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
#endif // __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
		///End WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS

		if(bData)
		///End MODIFICATION_TEXTCONTROL_OPTION
		///End ADD_RICH_TEXT_CHEKBOX
	    	tr.TextControl.Merge.SetAttribute("Combo", _L("None|Horizontal|Vertical|Both"));
	    else
	    	tr.TextControl.Merge.SetAttribute("Combo", _L("None|Horizontal"));
	    ///Folger 05/15/07 MODIFICATION_TEXTCONTROL_OPTION
	    tr.TextControl.Type.Show =
	    tr.TextControl.Display.Show =
	    tr.TextControl.DigitsMode.Show =
//------ CPY 2/26/08 QA70-11111 IGNORE_BLANK_MISSING_RANGE_STYLE	
//	    tr.TextControl.BlankMissing.Show =
//------
	    tr.TextControl.Ellipsis.Show =	///Jasmine 09/21/07 QA70-10401 HIDE_ELLIPSIS_FOR_LNAME_UNIT_COMMENT
	    tr.TextControl.AllowEnter.Show = bData;//!nCmp;
//------ CPY 2/26/08 QA70-11111 IGNORE_BLANK_MISSING_RANGE_STYLE	
		if(tr.TextControl.BlankMissing)
			tr.TextControl.BlankMissing.Show = bData;
//------
		tr.TextControl.ReadOnly.Show = bData || bLabel || bStandard;///Jasmine 11/11/09 QA80-14602 ADD_READONLY_CHECKBOX

		///Kyle 07/22/2009 QA80-12339-P1 WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
#ifdef __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
		///Kyle 07/31/2009 QA80-12339-P4 WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
		//tr.TextControl.Merge.Show = !bHeader && strOgName.CompareNoCase("ogSampleRate");
		tr.TextControl.Merge.Show = !bStandard && !bHeader && strOgName.CompareNoCase("ogSampleRate");
		tr.TextControl.WrapText.Show = !bStandard;
		tr.TextControl.Float.Show = !bStandard;
		///End WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
#else // __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
		///End WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
	    tr.TextControl.Merge.Show = strOgName.CompareNoCase("ogSampleRate");
		///Kyle 07/22/2009 QA80-12339-P1 WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
#endif // __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
		///End WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
	    ///End MODIFICATION_TEXTCONTROL_OPTION
	}
    ///End MODIFICATION_TEXTCONTROL_MERGE
    ///End FIXED_TEXTCONTROL_MERGE
    trProp = tree_get_node_by_tagname(trProp, strTagName, true);    
	if(!trProp.IsValid())
    	return false;
    if(trProp.Borders)
    	trProp.Borders.Remove();
    
    //make sure trFmt has these nodes, and set default value
    if(!trProp.WrapText)
    	trProp.WrapText.nVal = TRUE;
    if(!trProp.AllowEnter)
    	trProp.AllowEnter.nVal = TRUE;
    if(!trProp.Float)
    	trProp.Float.nVal = TRUE;
    ///Jasmine 09/21/07 QA70-10401 SELDOM_USE_SO_REMOVE_FLOOD
    //if(!trProp.Flood)
    	//trProp.Flood.nVal = TRUE;//FALSE; ///Jasmine 08/08/07 default is true
    ///End SELDOM_USE_SO_REMOVE_FLOOD
    ///Jasmine 11/11/09 QA80-14602 ADD_READONLY_CHECKBOX
    if(!trProp.ReadOnly)
    	trProp.ReadOnly.nVal = FALSE;
    ///End ADD_READONLY_CHECKBOX
    ///Folger 05/15/07 FIXED_TEXTCONTROL_MERGE
    ///Folger 05/14/07 MODIFICATION_TEXTCONTROL_MERGE
    if(!trProp.Merge)
    {
    	trProp.Merge.nVal = GMC_NONE;
    	///Folger 05/15/07 MODIFICATION_TEXTCONTROL_OPTION
    	//if (!strOgName.IsEmpty())
    	if (!strOgName.IsEmpty() && !bData)//nCmp)
    	///End MODIFICATION_TEXTCONTROL_OPTION
    	{
	    	trProp.Merge.nVal = GMC_HORZ;
    	}
    }
    ///End MODIFICATION_TEXTCONTROL_MERGE
    ///End FIXED_TEXTCONTROL_MERGE
    if(!trProp.BlankMissing)
    	trProp.BlankMissing.nVal = FALSE;
    if(!trProp.Format)
    	trProp.Format.strVal = "";
    ///Folger 05/09/07 ADD_STYLE_CONTROL
#ifdef ADD_STYLE_CONTROL
    if (!trProp.Control)
    	trProp.Control.strVal = strOgName.CompareNoCase("ogUnit")? "Edit Control":"Origin Text Edit";	///Jasmine 06/12/07 ADD_RICH_TEXT_CHEKBOX	
#endif
    ///End ADD_STYLE_CONTROL
    //---------Folger 07/10/07 ADD_ELLIPSIS_INTO_TEXT_FORMAT 
    if(!trProp.Ellipsis)
    	trProp.Ellipsis.nVal = 0;
    //---------end ADD_ELLIPSIS_INTO_TEXT_FORMAT
    
	///Kyle 07/22/2009 QA80-12339-P1 WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
#ifdef __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__

	///Kyle 07/31/2009 QA80-12339-P4 WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
	TreeNode trText = tr;
	if(!bCommonStyle)
		trText = trText.TextControl;

	//if(trText.Hint)
		//trText.Hint.Show = bStandard;

	// update gui structure, no branch is needed if standard
	bool bBranch = !(bStandard || bCommonStyle);
	_update_text_format_structure(trText, bBranch);
	_get_text_font_color_setting(trText, trProp, bBranch);

	///End WKS_PROPERTIES_FORMAT_ADD_APPLY_TO_ALL_OPTION
#endif // __WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS__
	///End WKS_PROPERTIES_FORMAT_ADD_HEADERS_OPTION_AND_FONT_CONTROLS
    int iRet = obj.UpdateThemeIDs(trFmt.Root, "Error", "Unknown tag");
    octree_copy_values_by_id(&trProp, &tr, false, STR_ID_ATTRIB, STR_DATAID_ATTRIB);
    convert_theme_setting_to_gui(tr);  //convert_format_string_node(tr);
    ///Jsamine 09/24/07 QA70-10353 CP_FIX_ALLOWENTER_BUG
    /*
    //---------Folger 07/10/07 ADD_ELLIPSIS_INTO_TEXT_FORMAT
    TreeNode trEllipsis = tree_get_node_by_tagname(tr, "Ellipsis", true);
    if (trEllipsis)
    {
    	TreeNode trAllowEnter = tree_get_node_by_tagname(tr, "AllowEnter", true);
    	if (trAllowEnter)
    		//trAllowEnter.Enable = !trEllipsis.nVal;
    		trEllipsis.Enable = !trAllowEnter.nVal;///Jasmine 09/06/07 SHOW_ERROR_MESSAGE
    }
    //---------end ADD_ELLIPSIS_INTO_TEXT_FORMAT
    */
    ///End CP_FIX_ALLOWENTER_BUG
    ///Jasmine 06/12/07 ADD_RICH_TEXT_CHEKBOX
#ifdef ADD_STYLE_CONTROL
	//------Folger 07/23/07 SHOW_RICH_TEXT_WHEN_LONG_NAME_CHOSEN
    //vector<string> vsAllowControl = {"ogData", "ogUnit", "ogComment", "ogParam", "ogUDL"};
    ///Kyle 08/12/2009 QA80-12339-P6 WKS_PROPERTIES_FORMAT_ADD_COLUMN_LABELS_OPTION
    //vector<string> vsAllowControl = {"ogLongName", "ogData", "ogUnit", "ogComment", "ogParam", "ogUDL"};
    vector<string> vsAllowControl = {"ogLongName", "ogData", "ogUnit", "ogComment", "ogParam", "ogUDL", "ogColLabel"};
    ///End WKS_PROPERTIES_FORMAT_ADD_COLUMN_LABELS_OPTION
    //------End SHOW_RICH_TEXT_WHEN_LONG_NAME_CHOSEN
    ///Folger 06/27/07 FIX_ORIGINTEXTCONTROL_SHOW
    //tr.TextControl.OriginTextControl.Show = -1 < vsAllowControl.Find(strOgName);
    //_rich_text_change_event(tr, 0, 0, tr.TextControl.OriginTextControl, 0, 0, NULL);
    TreeNode trOriginTextControl = tree_get_node_by_tagname(tr, "OriginTextControl", true);
    if (trOriginTextControl)
    {
    	trOriginTextControl.Show = !strTagName.CompareNoCase("CommonStyle") || -1 < vsAllowControl.Find(strOgName);
    	_rich_text_change_event(tr, 0, 0, trOriginTextControl, 0, 0, NULL);
    }
    ///End FIX_ORIGINTEXTCONTROL_SHOW
#endif
    ///End ADD_RICH_TEXT_CHEKBOX
    ///Jasmine 05/10/07 MODIFICATION_FORMAT_STRING_FOR_DATE_TIME
	TreeNode trType = tree_get_node_by_tagname(tr, "Type", true);
    TreeNode trDisplay = tree_get_node_by_tagname(tr, "Display", true);
	TreeNode trDigitsMode = tree_get_node_by_tagname(tr, "DigitsMode", true);
	TreeNode trDigitsNumber = tree_get_node_by_tagname(tr, "DigitsNumber", true);
	if(trType && trDisplay && trDigitsMode && trDigitsNumber)
	{
		string strCombo;
		switch(trType.nVal)
		{
		case TYPE_TEXT_NUMERIC:
			strCombo = STR_DATA_DISPLAY_MODE_LIST;
			break;
		case TYPE_TIME:
			strCombo = STR_COL_TIME_DISPLAY_LIST;
			break;
		case TYPE_DATE:
			strCombo = _get_current_data_display_list();
			break;
		}
		trDisplay.SetAttribute(STR_COMBO_ATTRIB, strCombo);
		trDigitsMode.Show = trDigitsNumber.Show = false;
		///Folger 05/15/07 MODIFICATION_TEXTCONTROL_OPTION
		//if(TYPE_TEXT_NUMERIC == trType.nVal)
		if(bData && TYPE_TEXT_NUMERIC == trType.nVal)
		///End MODIFICATION_TEXTCONTROL_OPTION
		{
			trDigitsMode.Show = true;
			trDigitsNumber.Show = trDigitsMode.nVal > 0;
		}
	///End MODIFICATION_FORMAT_STRING_FOR_DATE_TIME
		if(1 == trDigitsNumber.Show)
		{
			string strLabel = NUMERIC_SET_DECIMAL_PLACES==trDigitsMode.nVal? STR_DECIMAL_PLACES_LABEL:STR_SIGNIFICANT_PLACES_LABEL;

			trDigitsNumber.SetAttribute(STR_LABEL_ATTRIB, strLabel);
		}
	}
	return true;
}
static bool convert_theme_setting_to_gui(TreeNode& tr)//convert_format_string_node
{
	TreeNode trType = tree_get_node_by_tagname(tr, "Type", true);
	TreeNode trDisplay = tree_get_node_by_tagname(tr, "Display", true);
	TreeNode trDigitsMode = tree_get_node_by_tagname(tr, "DigitsMode", true);
	TreeNode trDigitsNumber = tree_get_node_by_tagname(tr, "DigitsNumber", true);
	TreeNode trFormat = tree_get_node_by_tagname(tr, "Format", true);
	if(!trType || !trDisplay || !trDigitsMode || !trDigitsNumber || !trFormat)
		return false;
	string strFmt = trFormat.strVal;
	///Jasmine 04/19/07 MORE_WORK_ON_NUMERIC_DEFAULT_DECIMAL
	///Jasmine 05/10/07 MODIFICATION_FORMAT_STRING_FOR_DATE_TIME
	int nFormat, nSigDigits, nDigitsMode;
	int nType = make_date_time_setting_from_format_str(strFmt, nFormat);
	trType.nVal = nType;
	if(nType)
		trDisplay.nVal = nFormat;
	///End MODIFICATION_FORMAT_STRING_FOR_DATE_TIME
	else			
	{
		BOOL bRemoveEndZeros;//bIsUseDecimalDigits
		BOOL bRet = make_numeric_settings_from_format_str_ex(strFmt, nFormat, nSigDigits, nDigitsMode, bRemoveEndZeros);
		_put_format_type_to_gui(nFormat);
		trDisplay.nVal = nFormat;
		//if(strFmt.IsEmpty())
			//trDigitsMode.nVal = 0;
		//else
			//trDigitsMode.nVal = nIsUseDecimalDigits? NUMERIC_SET_DECIMAL_PLACES:NUMERIC_SET_SIGNIFICANT_DIGITS;
		trDigitsMode.nVal =	nDigitsMode;
		///End MORE_WORK_ON_NUMERIC_DEFAULT_DECIMAL
		trDigitsNumber.strVal = nSigDigits;
	}
	///Jasmine 06/12/07 ADD_RICH_TEXT_CHEKBOX
	///Folger 05/09/07 ADD_STYLE_CONTROL
#ifdef ADD_STYLE_CONTROL
	TreeNode trOriginTextControl = tree_get_node_by_tagname(tr, "OriginTextControl", true);	///Jasmine 06/12/07 ADD_RICH_TEXT_CHEKBOX
	TreeNode trControl = tree_get_node_by_tagname(tr, "Control", true);			///Folger 05/09/07 ADD_STYLE_CONTROL
	if(!trOriginTextControl || !trControl)
		return false;
	if (trControl.strVal.CompareNoCase("Origin Text") == 0 || trControl.strVal.CompareNoCase("Origin Text Edit") == 0)
	{
		trOriginTextControl.nVal = 1;
	}
	else
	{
		trOriginTextControl.nVal = 0;
	}
#endif
	///End ADD_STYLE_CONTROL
	///End ADD_RICH_TEXT_CHEKBOX
	return true;
}

/// TD 01-05-2008 QA80-12470 LT_INVOKE_Worksheet_Properties_dialog
//static bool convert_gui_setting_to_theme(TreeNode& tr)//convert_numeric_setting_node
static bool convert_gui_setting_to_theme(TreeNode& tr, bool bRelyOnChangeAttribute = true)//convert_numeric_setting_node
/// end LT_INVOKE_Worksheet_Properties_dialog
{
	//------ Folger 02/26/08 QA80-11113-P2 CENTRALIZE_SET_CONTROL_AND_FORMAT_CHANGED
	string strVal;
	TreeNode trFormat = tree_get_node_by_tagname(tr, "Format", true);
	/// TD 01-05-2008 QA80-12470 LT_INVOKE_Worksheet_Properties_dialog
	//if ( trFormat.GetAttribute(STR_CHANGED_ATTRIB, strVal) )
	if (!bRelyOnChangeAttribute ||  trFormat.GetAttribute(STR_CHANGED_ATTRIB, strVal) )
	/// end LT_INVOKE_Worksheet_Properties_dialog
	{
	//------
		///Jasmine 05/10/07 MODIFICATION_FORMAT_STRING_FOR_DATE_TIME
		TreeNode trType = tree_get_node_by_tagname(tr, "Type", true);
		TreeNode trDisplay = tree_get_node_by_tagname(tr, "Display", true);
		TreeNode trDigitsMode = tree_get_node_by_tagname(tr, "DigitsMode", true);
		TreeNode trDigitsNumber = tree_get_node_by_tagname(tr, "DigitsNumber", true);
		//------ Folger 02/26/08 QA80-11113-P2 CENTRALIZE_SET_CONTROL_AND_FORMAT_CHANGED
		//TreeNode trFormat = tree_get_node_by_tagname(tr, "Format", true);
		//------
		if(!trType || !trDisplay || !trDigitsMode || !trDigitsNumber || !trFormat)
			return false;
		string strFormat;
		int nType = trType.nVal;
		int nFormat = trDisplay.nVal;
		if(!make_format_str_from_date_time_settings(nType, nFormat, strFormat))
		///End MODIFICATION_FORMAT_STRING_FOR_DATE_TIME
		{
			char szBuffer[MAXLINE];
			_get_format_type_from_gui(nFormat);
			int nSigDigits = atoi(trDigitsNumber.strVal);
			///Jasmine 04/19/07 MORE_WORK_ON_NUMERIC_DEFAULT_DECIMAL
			//bool bIsUseDecimalDigits = NUMERIC_SET_SIGNIFICANT_DIGITS == trDigitsMode.nVal;
			bool bIsUseDecimalDigits = NUMERIC_SET_DECIMAL_PLACES == trDigitsMode.nVal;
			///End MORE_WORK_ON_NUMERIC_DEFAULT_DECIMAL
			///Jasmine 04/03/07 REMOVE_NUMERIC_IF_NUMERIC_DEFAULT_DECIMAL
			//if(NUMERIC_DEFAULT_DECIMAL == trDigitsMode.nVal)
				//nSigDigits = 5;
			if(bIsUseDecimalDigits)  
				nSigDigits+=3;
			BOOL bRet = make_format_str_from_numeric_settings_ex(szBuffer, nFormat, 
											nSigDigits, bIsUseDecimalDigits, false, false);
			strFormat = szBuffer;
			if(NUMERIC_DEFAULT_DECIMAL == trDigitsMode.nVal)//remove last numeric char
			{
				int nLength = strFormat.GetLength();
				for(int ii = nLength - 1; ii >= 0; ii--)
				{
					string strLast = strFormat.Right(1);
					if(!is_numeric(strLast))
						break;
					strFormat.Delete(ii);
				}
			}
			///End REMOVE_NUMERIC_IF_NUMERIC_DEFAULT_DECIMAL
		}
		trFormat.strVal = strFormat;
	//------ Folger 02/26/08 QA80-11113-P2 CENTRALIZE_SET_CONTROL_AND_FORMAT_CHANGED
	}
	TreeNode trControl = tree_get_node_by_tagname(tr, "Control", true);
	/// TD 01-05-2008 QA80-12470 LT_INVOKE_Worksheet_Properties_dialog
	//if ( trControl.GetAttribute(STR_CHANGED_ATTRIB, strVal) )
	if (!bRelyOnChangeAttribute || trControl.GetAttribute(STR_CHANGED_ATTRIB, strVal) )
	/// end LT_INVOKE_Worksheet_Properties_dialog
	{
	//------
		///Jasmine 06/12/07 ADD_RICH_TEXT_CHEKBOX
	#ifdef ADD_STYLE_CONTROL
		TreeNode trOriginTextControl = tree_get_node_by_tagname(tr, "OriginTextControl", true);	///Jasmine 06/12/07 ADD_RICH_TEXT_CHEKBOX
		//------ Folger 02/26/08 QA80-11113-P2 CENTRALIZE_SET_CONTROL_AND_FORMAT_CHANGED
		//TreeNode trControl = tree_get_node_by_tagname(tr, "Control", true);			///Folger 05/09/07 ADD_STYLE_CONTROL
		//------
		if(!trOriginTextControl || !trControl)
			return false;
		trControl.strVal = trOriginTextControl.nVal? "Origin Text Edit":"Edit Control";
	#endif
		///End ADD_RICH_TEXT_CHEKBOX
	//------ Folger 02/26/08 QA80-11113-P2 CENTRALIZE_SET_CONTROL_AND_FORMAT_CHANGED
	}
	//------
	return true;
}

static BOOL make_numeric_settings_from_format_str_ex(
	LPCSTR lpcszFmt,
	int& nFormat,
	int& nSigDigits,
	int& nDigitsMode,//BOOL& bIsUseDecimalDigits,///Jasmine 04/19/07 MORE_WORK_ON_NUMERIC_DEFAULT_DECIMAL
	BOOL& bRemoveEndZeros)
{
	string strFmt = lpcszFmt;
	char cFmt;
	bool bDelete;
	//check format
	nFormat = -1;//default
	if(!strFmt.IsEmpty())
	{
		cFmt = strFmt.GetAt(0);
		bDelete = true;
		switch(cFmt)
		{
		case ',':
			nFormat = LABELS_NUM_COMMA;
			break;
		case 'E':
			nFormat = LABELS_NUM_ENG;
			break;
		case 'S':
			nFormat = LABELS_NUM_SCI;
			break;
		default:
			bDelete = false;
			break;
		}
		if(bDelete)//remove the first specified char
			strFmt.Delete(0);
	}
	//check nDigitsMode
	//bIsUseDecimalDigits = true;
	if(!strFmt.IsEmpty())
	{
		cFmt = strFmt.GetAt(0);
		bDelete = true;
		switch(cFmt)
		{
		case '*':
			nDigitsMode = NUMERIC_SET_SIGNIFICANT_DIGITS;//bIsUseDecimalDigits = false;///Jasmine 04/19/07 MORE_WORK_ON_NUMERIC_DEFAULT_DECIMAL
			break;
		case '.':
			nDigitsMode = NUMERIC_SET_DECIMAL_PLACES;//nIsUseDecimalDigits = true;///Jasmine 04/19/07 MORE_WORK_ON_NUMERIC_DEFAULT_DECIMAL
			break;
		default:
			bDelete = false;
		}
		if(bDelete)
			strFmt.Delete(0);
	}
	//check bRemoveEndZeros
	bRemoveEndZeros = false;
	if(!strFmt.IsEmpty())
	{
		string strLast = strFmt.Right(1);
		bRemoveEndZeros = !strLast.Compare("*");
		strFmt.Remove('*');
	}
	//check nSigDigits
	///Jasmine 04/19/07 MORE_WORK_ON_NUMERIC_DEFAULT_DECIMAL
	nSigDigits = _get_system_digits_setting();
	if(NUMERIC_SET_SIGNIFICANT_DIGITS == nDigitsMode)
		nSigDigits = DEC_PLACES_TO_SDIGITS(nSigDigits);
	///End MORE_WORK_ON_NUMERIC_DEFAULT_DECIMAL
	if(!strFmt.IsEmpty())
		nSigDigits = atoi(strFmt);
	else
		nDigitsMode = NUMERIC_DEFAULT_DECIMAL;//Jasmine 04/19/07 MORE_WORK_ON_NUMERIC_DEFAULT_DECIMAL, no number means to use default setting/
	return TRUE;  	
}
///Jasmine 05/10/07 MODIFICATION_FORMAT_STRING_FOR_DATE_TIME
static int make_date_time_setting_from_format_str(LPCSTR lpcszFmt, int& nFormat)
{
	int nType = TYPE_TEXT_NUMERIC;
	nFormat = 0;
	string strFmt = lpcszFmt;
	char cFmt;
	if(!strFmt.IsEmpty())
	{
		cFmt = strFmt.GetAt(0);
		switch(cFmt)
		{
		case 'T':
			nType = TYPE_TIME;
			break;
		case 'D':
			nType = TYPE_DATE;
			break;
		default:
			return nType;
		}
		strFmt.Delete(0);
		if(!strFmt.IsEmpty())
			nFormat = atoi(strFmt);
	}
	return nType;
}

static bool make_format_str_from_date_time_settings(const int nType, const int nFormat, string& strFormat)
{
	string str;
	switch(nType)
	{
	case TYPE_TIME:
		str = "T";
		break;
	case TYPE_DATE:
		str = "D";
		break;
	default:
		return false;
	}
	strFormat.Format("%s%d", str, nFormat);
	return true;
}
///End MODIFICATION_FORMAT_STRING_FOR_DATE_TIME

///Jasmine 07/26/07 NAME_STYLE_N_IS_NOT_RELIABLE
static TreeNode theme_tree_get_node_by_name_strval(TreeNode trRoot, LPCSTR lpcszVal)///Jasmine 08/08/07 wanted by wks_utils
{
	TreeNode trProp;
	TreeNode trNameStyles;
	bool bRet = octree_theme_tree_get_node_by_id(&trNameStyles, &trRoot, OTID_NAMESTYLES, 3, true);	
	
	if(trNameStyles)
	{
		foreach(TreeNode trNode in trNameStyles.Children)
		{
			TreeNode trName;
			bRet = octree_theme_tree_get_node_by_id(&trName, &trNode, OTID_NAMESTYLE_NAME, 3, true);
			if(trName && 0 == trName.strVal.CompareNoCase(lpcszVal))
			{
				trProp = trName.Parent();
				break;
			}
		}
	}
	return trProp;
}
///End NAME_STYLE_N_IS_NOT_RELIABLE

//------ Folger 02/26/08 QA80-11113-P2 CENTRALIZE_SET_CONTROL_AND_FORMAT_CHANGED
// centralize code about set treenode attribute of Control and Format both in CellFormat and WksProperties
static void set_control_and_format_changed(TreeNode& trGUI, const TreeNode &trChanged)
{
	vector<string> vs = {"Type", "Display", "DigitsMode", "DigitsNumber"};
	string strVal;
	
	TreeNode trControl = tree_get_node_by_tagname(trGUI, "Control", true);
	if(!trControl.GetAttribute(STR_CHANGED_ATTRIB, strVal) && !trChanged.tagName.CompareNoCase("OriginTextControl"))
		trControl.SetAttribute(STR_CHANGED_ATTRIB, "1");
	
	TreeNode trFormat = tree_get_node_by_tagname(trGUI, "Format", true);
	if(!trFormat.GetAttribute(STR_CHANGED_ATTRIB, strVal) && -1 < vs.Find(trChanged.tagName))
		trFormat.SetAttribute(STR_CHANGED_ATTRIB, "1");
}

#endif		//__TEXT_FORMAT__
